#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{

	
	

	[TestFixture]
	public class Common_DataItem : BaseTest 
	{

		private Common.DataItem _testDataItem;
		private string _tmpId = System.DateTime.Now.ToString();
		private string _tmpValue = System.DateTime.Now.ToString();


		[SetUp]
		protected void SetUp() 
		{	
			this.BaseSetUp();
			
			this._testDataItem = new Common.DataItem(this._tmpId, this._tmpValue);
		}

		[Test]
		public void Ctor_Pass()
		{
			Common.DataItem tstValue = new Common.DataItem(this._tmpId, this._tmpValue);

			Assert.IsNotNull(tstValue, "NotNull");

			Assert.AreEqual(this._tmpId, tstValue.ID, "Id");
			Assert.AreEqual(this._tmpValue, tstValue.Value, "Value");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Id_Pass()
		{
			Assert.AreEqual(this._tmpId, this._testDataItem.ID);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Id_Fail()
		{
		}

		[Test]
		public void Value_Pass()
		{
			Assert.AreEqual(this._tmpValue, this._testDataItem.Value);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Value_Fail()
		{
		}

		[Test]
		public void ToString_Pass()
		{
			Assert.AreEqual(this._tmpValue, this._testDataItem.ToString());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ToString_Fail()
		{
		}

	}

}
#endif

